/* -----------------------------------------------------------------------------------------------------------------------------*
 *                   Functionality for "MenulocalizedGermany", "MenulocalizedUSA" and "MenulocalizedJapan"			*
 *																*
 * -----------------------------------------------------------------------------------------------------------------------------*/

//The following set of constants determines a part of the layout:

var control_offset = 250; 	// horizonzal position for control buttons start
var control_space = 100; 	// space from one control button (middle) to the next
var control_button_y = 520;	// control buttons height
var c_padding = 5; 		// space from the control-button edges left and right to the text
var mbutton_padding = 60; 	// space from the menu-button edges left (and right) to the text
var m_icon_padding = 15;	// space  from the menu-button edges left to the icon
var mbutton_text_y = -5;	// corrects the vertical position of the menu-button text
var topMenu_text_y = -8;	// corrects the vertical position of the top-menu text
var control_text_x = 0;		// corrects the horizontal position of the control-button text
var control_text_y = 18;	// corrects the vertical position of the control-button text
var space = 50;			// vertical position of the menu-buttons
var hor = 50;			// horizontal position of the menu-buttons 
var offset= 130;		// vertical start position of the the first menubutton
var category_x = 110;		// horizontal position of the category icon
var category_y = 520;		// vertical position of the the category icon

var active_button_group; 	// menubutton (with text and icon), that currently has the focus 
var scrolling = false;		// indication for scrolling, default is false, will be true if more than 8 menubuttons
var control_texts = new Array();// array with the text-elements of the MenuButtons
var button_text = new Array(); 	// array with the text-elements of the control-buttons if available
var button_icons = new Array() 	// array with menubutton icons
var buttons = new Array() 	// array with menubutton groups
var active_b_index = 0;		// index of the focused button in the array "buttons"
var started = false; 		// indication for mp3 starting, used to determine if the stop-button should do anything
var nrButtons = 0; 		// stores the number of menu buttons of this screen 
var position = 1;		// indication for the position of the active button on the screen
var lowerInvisible = 7;		// index of the first invisible button if the list is too long
var upperInvisible = -1;	// the index of the last invisible button if the list is too long


var en = '..\\..\\..\\English\\Phase2Representation\\GUI\\SID_MAINMENU.svg'; 	//path for English content
var de = '..\\..\\..\\German\\Phase2Representation\\GUI\\SID_MAINMENU.svg'; 	//path for German content
var ja = '..\\..\\..\\Japanese\\Phase2Representation\\GUI\\SID_MAINMENU.svg'; 	//path for Japanese content

/*This function is called as soon as all the components of the svg are fully loaded. 
* It places the menu- and controlbuttons and all the icons and texts. Determines if scrolling is necessary and
* in this case hides the overflowing buttons. It adds EventListeners to the buttons to enable them to
* react to mouseover, mouseout and click
*/
function init()
{

	//counts the elements to determine the number of buttons
	var el =  document.getElementById("MenuButtons").firstChild;
	while(el)
	{
		if(el.getNodeType()==1)nrButtons++;
		el = el.nextSibling;
	}

	if(nrButtons == 8) offset = 95; /*if the number of buttons is 8, it starts at y position 95, otherwise 
					*it starts at y position 130
					*/

	var el = document.getElementById("ScrollUp");		//gets Up-Arrow
	el.setAttribute("fill","grey");				//in the initial State, the Up-Arrow is not focused
	el.addEventListener("click", prevMenuPoint, false);	//Up-Arrow gets an Event to react to mouse clicks (function prevMenuPoint)

	el = document.getElementById("ScrollDown");
	el.addEventListener("click", nextMenuPoint, false);

	if (nrButtons > 8) 
	{	
		scrolling = true;
	}
	var x = nrButtons;
	
	//places the TopMenu at its position x=50, y=40
	document.getElementById("TopMenu").setAttribute("transform", "translate(50,40)");
	
	//if this is not the mainmenu, it gets the text for the TopMenu and stores it in the Variable topText

	var topText = document.getElementById("TopMenu").firstChild.nextSibling.firstChild.nextSibling.nextSibling.nextSibling;
	
	//if the text for the TopMenus already exists, 
	if(topText){
	//gets the height in a var height
	var height =  document.getElementById("TopMenu").firstChild.nextSibling.firstChild.nextSibling.getAttribute("height");
	//puts it at its position  
	topText.setAttribute("transform","translate("+mbutton_padding+","+(height/2+(topText.getStyle().getPropertyValue("font-size")/2)+topMenu_text_y)+")");
	}
	
	//gets the element with the name MenuButtons and finds the first button group (icon+graphic+button text)
	var button_group = document.getElementById("MenuButtons").firstChild.nextSibling; 
	active_button_group =  button_group;

	//for each menubutton(group) do
	for(var i=0; i != x; i++)
	{	
		buttons[i] = button_group;				//puts the button group in the array
		var width = button_group.getAttribute("width");		//reads width and height of the button group
		var height = button_group.getAttribute("height");
	        
	        //determines the element of the button-group (the graphic) that visualizes the unfocused button
	        var button_inactive = button_group.firstChild.nextSibling.firstChild.nextSibling;
	        
	        //determines the element of the button-group that visualizes the focused button (initially hidden)
		var button_active = button_inactive.nextSibling.nextSibling;
		
		//determines the element of the button-group that is the button-text and load it into an array
		var text = button_active.nextSibling.nextSibling;
		button_text[i]=text;
		
		//determines the element of the button-group that is the button-icon and load it into an array
		button_icons[i] = text.nextSibling.nextSibling;
		
		//reads out the actual font-size of the button-text to be used while adapting the font-size if the text is too long 
		var size = text.getStyle().getPropertyValue("font-size");
		
			//reads the length of the text in pixel and looks if it fits into the button with some space to the edges
			//if not the font-size is adapted till it does
			//distance for both margens= 2*mbutton_padding 
			while(text.getComputedTextLength() > width-2*mbutton_padding){
			size--;//text size gets 1 smaller
			text.getStyle().setProperty("font-size", size);//Button text gets the new size	
			}
			
		//computes the vertical position of this button
		var n = offset+(i*space);
		
		//places the button at that position
		button_group.setAttribute("transform", "translate("+hor+","+n+")");
		
		//if this button is the 8th or higher and scrolling is necessary, the button will be hidden
		if(scrolling){
			if(i>6)
			{
				button_group.setAttribute("style","visibility:hidden");
			}
		}
		
		//computes the position of the text within the buttongroup and place it there
		button_text[i].setAttribute("transform", "translate("+mbutton_padding+","+(height/2+(button_text[i].getStyle().getPropertyValue("font-size")/2)+mbutton_text_y)+")");
		
		//computes the position of the icon within the buttongroup and place it there
		button_icons[i].setAttribute("transform", "translate("+m_icon_padding+","+(height/2-(button_icons[i].getAttribute("height")/2))+")");
		
		//enables buttons to react to mouseover and click
		button_inactive.addEventListener("mouseover", focusin, false);
		button_active.addEventListener("click", universalFunction, false);
		
		//if there are more buttons, switch to the next
		if(button_group.nextSibling.nextSibling)
		{
		button_group = button_group.nextSibling.nextSibling;
		}
	}
	
	//if this screen has control-buttons, they need to be placed as well
	if(document.getElementById("Controls"))
	{

		x = 0;
		el =  document.getElementById("Controls").firstChild.nextSibling; //first control button group
		
		//cycles through the control-buttons
		while(el)
		{
		
			
			//places button at the right position. control_space=distance between the ControlButtons
			el.setAttribute("transform", "translate("+(control_offset+x*control_space)+","+control_button_y+")");

			//enables button to react to mouseover and mouseout
			el.firstChild.nextSibling.addEventListener("mouseover", highlight, false);
			el.firstChild.nextSibling.nextSibling.nextSibling.addEventListener("mouseout", dehighlight, false);

			//reads the buttons width
			var width = el.getAttribute("width");

			//gets the node button-text of the ControlButton element and loads it into the array.
			control_texts[x] = el.firstChild.nextSibling.nextSibling.nextSibling.nextSibling.nextSibling;

			//reads out the actual font-size of the button-text (x element of array control_texts) to be used while 
			//adapting the font-size if the text is too long 
			var size = control_texts[x].getStyle().getPropertyValue("font-size");

			//reads the length of the text in pixel and look if it fits into the button 
			//with some space to the edges. If not the font-size is adapted till it does
			while(control_texts[x].getComputedTextLength() > width-2*c_padding)
			{
				size--;
				control_texts[x].getStyle().setProperty("font-size", size);
			}

			//corrects the position of the text. Control_text_x (0) plus half of the width of the ControlButton plus control_text_y (0)^

			control_texts[x].setAttribute("transform", "translate("+(control_text_x+(width/2))+","+control_text_y+")");
			x++; 


			//next Control Button group if there is one
			el = el.nextSibling.nextSibling;
		}
	}

	//places the category-icon at its position
	document.getElementById("category").setAttribute("transform", "translate("+category_x+","+category_y+")");
	
	//activates the first buttons "focused"-view
	active_button_group.firstChild.nextSibling.firstChild.nextSibling.nextSibling.nextSibling.setAttribute("style", "visibility:visible");
}

/*This is a highlight-function for the control button, called when the mouse is over it. 
*/
function highlight(evt){
	//the attribute of the event receiver (graphic of the not focused ControlButton) will be visible
	evt.target.setAttribute("style", "visibility:hidden");

	//the attribute of the event receiver (graphic of the focused ControlButton) will be visible
	evt.target.nextSibling.nextSibling.setAttribute("style", "visibility:visible");
	
}

/*This is a highlight-function for the control button, called when the mouse is out of it. 
*/
function dehighlight(evt){

	evt.target.setAttribute("style", "visibility:hidden");
	evt.target.previousSibling.previousSibling.setAttribute("style", "visibility:visible");
}


/*This function is called if the 8 on the NumPad is pressed or the up-arrow on the screen is clicked.   
* It activates the menubutton that is above the active one and deactivates this one. 
* If scrolling is necessary it does so. 
*/
function prevMenuPoint(){

	if(active_b_index!=0)
	
	{//not the first Button, if the first button, there is no previous MenuButton

		//if the focused MenuButton is not the first
		if(position!=1){
			position--; //one position up for the focus. Scrolling is not needed.
		}	
		else //the focused MenuButton is the first one
		{	
			if(scrolling)	//the active button is at the upper edge of the screen and scrolling is possible

			{ 				
				//all the buttons are moved down one step and the overflowing one is hidden and the first
				//incomming is shown
				
				for(var i=0; i != nrButtons; i++)
				{
					//reads the position of the buttons for moving them one step
					var att = buttons[i].getAttribute('transform');
					//calculates the new position of the buttons. X axe ist the same. For the Y axe adds the distance (space) of a button
					var trans ="translate("+att.substring(att.indexOf('(')+1,att.indexOf(','))+","+((att.substring(att.indexOf(',')+1,att.length-1))-(-space))+")";
					buttons[i].setAttribute("transform", trans);
				}
				// the upper button will be visible 
				buttons[upperInvisible].setAttribute("style", "visibility:visible");
				lowerInvisible--;
				// the lower button will be hidden 
				buttons[lowerInvisible].setAttribute("style", "visibility:hidden");
				upperInvisible--;

			}
		}
		
		//checks if the down-arrow must be enabled
		if(active_b_index==(nrButtons-1))document.getElementById("ScrollDown").setAttribute("fill","black");
		
		//checks if the up-arrow must be disabled
		if(active_b_index==1)document.getElementById("ScrollUp").setAttribute("fill","grey");
		
		//actualizes the index, hiding the active part of the old button and showing that of the new
		active_b_index--;
		buttons[active_b_index].firstChild.nextSibling.firstChild.nextSibling.nextSibling.nextSibling.setAttribute("style", "visibility:visible");
		active_button_group.firstChild.nextSibling.firstChild.nextSibling.nextSibling.nextSibling.setAttribute("style", "visibility:hidden");
		active_button_group = buttons[active_b_index];
	}
}

/*This function is called if the 2 on the NumPad is pressed or the down-arrow on the screen is clicked.   
* It activates the menubutton that is below the active one and deactivates this one. 
* If scrolling is necessary it does so. If there is is none below it does nothing.
*/
function nextMenuPoint(){

	 if(active_b_index!=(nrButtons-1))
	 
	 {//not the last Button
	 
		if(position!=7){
			position++;	//one position down
		}	
		else 
		{	
			if(scrolling)	//the active button is at the lower edge of the screen and scrolling is possible
			{ 			
				//all the buttons are moved up one step and the overflowing one is hidden and the first
				//incomming is shown
				for(var i=0; i != nrButtons; i++)
				{
					var att = buttons[i].getAttribute('transform');
					buttons[i].setAttribute("transform", "translate("+att.substring(att.indexOf('(')+1,att.indexOf(','))+","+(att.substring(att.indexOf(',')+1,att.length-1)-space)+")");
				}
				buttons[lowerInvisible].setAttribute("style", "visibility:visible");
				lowerInvisible++;
				buttons[upperInvisible+1].setAttribute("style", "visibility:hidden");
				upperInvisible++;
			}
		}
		
		//checks if the up-arrow must be enabled
		if(active_b_index==0)document.getElementById("ScrollUp").setAttribute("fill","black");
		
		//checks if the down-arrow must be disabled
		if(active_b_index==(nrButtons-2))document.getElementById("ScrollDown").setAttribute("fill","grey");
		
		//actualizes the index, hiding the active part of the old button and showing that of the new
		active_b_index++;
		buttons[active_b_index].firstChild.nextSibling.firstChild.nextSibling.nextSibling.nextSibling.setAttribute("style", "visibility:visible");
		active_button_group.firstChild.nextSibling.firstChild.nextSibling.nextSibling.nextSibling.setAttribute("style", "visibility:hidden");
		active_button_group = buttons[active_b_index];
	}
}


/*This function handles the keyboard events.
*
*/
function keys(evt){
	if(evt.getKeyCode()==13){ 			// Enter 		--> action depends on what is active
		universalFunction();
	}
	if(evt.getKeyCode()==104){ 			// Up on NumPad		--> previous Menu Point
		prevMenuPoint();
	}
	if(evt.getKeyCode()==98){ 			// Down on NumPad	--> next Menu Point
		nextMenuPoint();
	}
	if(evt.getKeyCode()==100){ 			// Left on NumPad	--> one screen backwards
			window.history.go(-1);
	}
	if(evt.getKeyCode()==102){ 			// Right on NumPad	--> one screen forward
		window.history.go(1);
	}
	if(evt.getKeyCode()==80){ 			// "p"			--> play the actual mp3
		execute('SID_PLAY');
	}
	if(evt.getKeyCode()==83){ 			// "s"			--> stop the actual mp3
		execute('SID_STOP');
	}
	if(evt.getKeyCode()==27){ 			// "Esc"		--> to the mainmenu
		switchTo('SID_MAINMENU.svg');;
	}
	if(evt.getKeyCode()==77){ 			// "m"			--> Mute
		execute('SID_MUTE');
	}
	if(evt.getKeyCode()==44){ 			// ","			--> Search
		execute('SID_SEARCH');
	}
	if(evt.getKeyCode()==46){ 			// "."			--> Back
		window.history.go(-1);
	}
	//alert(evt.getKeyCode());
}

/*This function redirects the window to the screen whos adress is given in aim
*/
function switchTo(aim){
	window.location.href=aim;
}


/*This function is called by a button that receives a mouseover-event. It deactivates the active old button and activates the new one.
*
*/
function focusin(evt){

	//the active graphic of the active button will be unvisible
	active_button_group.firstChild.nextSibling.firstChild.nextSibling.nextSibling.nextSibling.setAttribute("style", "visibility:hidden");
	//the not active graphic of the buttons where the mouse is positioned will be visible
	evt.target.nextSibling.nextSibling.setAttribute("style", "visibility:visible");
	//the variable active_button_group will be updated for reading later which button is activ 
	active_button_group = evt.target.parentNode.parentNode;
	//stores the active button group for changing later
	var el =  active_button_group;
	//initials count variable
	var nr = 0;
	
	//counts the preceeding nodes to know the position of the activ button and calculates its index in the buttons-array
	//looks at the nodes in the same niveau

	while(el)
	{
		//counter increases for element nodes (NodeType 1) but not for text nodes
		if(el.getNodeType()==1)nr++;
		//previous node
		el = el.previousSibling;
	}
	//at the end there is allways oner more because of the starting index number 0, it will be rested
	nr--;
	//updates the position Variable
	position = position+(nr-active_b_index);
	//updates the Variable active_b_index
	active_b_index = nr;
	
	//checks if one of the arrows needs to be activated or deactivated
	if(active_b_index!=0)document.getElementById("ScrollUp").setAttribute("fill","black");
	if(active_b_index!=nrButtons-1)document.getElementById("ScrollDown").setAttribute("fill","black");
	if(active_b_index==0)document.getElementById("ScrollUp").setAttribute("fill","grey");
	if(active_b_index==nrButtons-1)document.getElementById("ScrollDown").setAttribute("fill","grey");
}

/*This function is used by the control buttons for external data like mp3, radio or video.
* Further functionality has to be implemented.
*@param client is the sid-String of the button that calls the function
*/		
function execute(client){

//determines in which context we are
var loc = window.location.href;

//reads the name of the file without the ending
var folder = loc.substring(loc.lastIndexOf('/')+1, loc.lastIndexOf('.'));


switch(client){
		case "SID_MUTE":	alert('Mute');			//just a message box
		break;
		case "SID_SEARCH": 	alert('Searching...');		//just a message box
		break;
		case "SID_BACK": 	window.history.go(-1);		//one screen back
		break;
		case "SID_PLAY": 	if(folder.search(/FOL_.+/)!=-1) //this is a single track in a folder, it will be played
							{
								var file = active_button_group.getAttribute("sid");
								file = file.substring(4,file.length)+'.mp3';
								switchTo('..\\mp3\\'+folder+'\\'+file);
								started=true;
							}
							else
							// this is a folder, get the whole playlist and play it
							// not implemented, just a message box
							{
							alert('playing '+ active_button_group.getAttribute("sid"));
							}
		break;
		case "SID_PAUSE": 	if(started)			//just a message box
							{
							alert(active_button_group.getAttribute("sid")+' paused.');
							}
		break;
		case "SID_STOP": 	if(started)			//just a message box
							{
							alert('Cant stop media player. Please stop manually');
							started = false;
							}
		break;
		default: 		alert('Not implemented yet!');	//message box
	}

}

/*This function is called whenever a functionality is asked for, that is not 
* implemented. At the moment it does nothing (but could if needed).
*/
function underConstructionFunction(){
	//does nothing
}

/*This function is used with the menubuttons and decides what to do in which context.
*/
function universalFunction(){

//checks which button is focused
var client = active_button_group.getAttribute("sid");

	if(client.search(/SID.+/)!=-1 || client.search(/FOL.+/)!=-1 )	// does nothing if the active button 
									// points to an Mp3 or radiostation
	{ 
		switch(client)	// depending on what is focused we do
		{
			case "SID_EXIT": alert('Off');			//just a message PopUp-Box with Off. 
									//break stops the rest of the cases in switch block

			break;
			case "SID_UC": window.history.go(-1);		// on screen backward
			break;
			case "SID_TRAFFICINFO": alert('No News');	//just a message box
			break;		
			
			// if this is the dvd - menu we call the underConstruction - Function, otherwise, we switch to the menu
			// in the chosen language
			case "SID_ENGLISH": 	if(window.location.href.search(/LANGUAGE.+/) != -1)underConstructionFunction();
						else switchTo(en);
			break;
			case "SID_GERMAN": 	if(window.location.href.search(/LANGUAGE.+/) != -1)underConstructionFunction();
						else switchTo(de);
			break;
			case "SID_JAPANESE": 	if(window.location.href.search(/LANGUAGE.+/) != -1)underConstructionFunction();
						else switchTo(ja);
			break;
			
			//The following functions are not implemented
			case "SID_NAVIGATION":	underConstructionFunction();
			break;	
			case "SID_COMMUNICATION": underConstructionFunction();
			break;	
			case "SID_CLIMATE": underConstructionFunction();
			break;	
			case "SID_INFORMATION": underConstructionFunction();
			break;	
			case "SID_ON": underConstructionFunction();
			break;	
			case "SID_OFF": underConstructionFunction();
			break;	
			case "SID_VOLUME": underConstructionFunction();
			break;	
			case "SID_CONTRAST": underConstructionFunction();
			break;
			case "SID_COLOR": underConstructionFunction();
			break;	
			case "SID_PLAY": underConstructionFunction();
			break;	
			case "SID_STOP": underConstructionFunction();
			break;	
			
			//if its none of them we switch to the file with name like [sidwithout'SID_'].svg
			default: switchTo(client+".svg");
		}
	}
	return false;//it is needed because the function will be called from an <a href> element that is blocked. 
}
